-- USE name_of_tested database  (insert only if needed and delete double dash at start of this row)
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[TestDBCMonitor1] 
AS

SET NOCOUNT ON
DECLARE @StartTime DATETIME, @EndTime DATETIME
SET @StartTime = CURRENT_TIMESTAMP;

IF OBJECT_ID('dbo.cmonitortest14051123654', 'U') IS NOT NULL
  BEGIN DROP TABLE dbo.cmonitortest14051123654
END
ELSE


CREATE TABLE dbo.cmonitortest14051123654	
(
	MyKeyField VARCHAR(10) NOT NULL,
	MyDate1 DATETIME NOT NULL,
	MyDate2 DATETIME NOT NULL,
	MyDate3 DATETIME NOT NULL,
	MyDate4 DATETIME NOT NULL,
	MyDate5 DATETIME NOT NULL
)

DECLARE @RowCount INT
DECLARE @RowString VARCHAR(10)
DECLARE @Random INT
DECLARE @Upper INT
DECLARE @Lower INT
DECLARE @InsertDate DATETIME

SET @Lower = -730
SET @Upper = -1
SET @RowCount = 0

WHILE @RowCount < 300
BEGIN
	SET @RowString = CAST(@RowCount AS VARCHAR(10))
	SELECT @Random = ROUND(((@Upper - @Lower -1) * RAND() + @Lower), 0)
	SET @InsertDate = DATEADD(dd, @Random, GETDATE())
	
	INSERT INTO dbo.cmonitortest14051123654
		(MyKeyField
		,MyDate1
		,MyDate2
		,MyDate3
		,MyDate4
		,MyDate5)
	VALUES
		(REPLICATE('0', 10 - DATALENGTH(@RowString)) + @RowString
		, @InsertDate
		,DATEADD(dd, 1, @InsertDate)
		,DATEADD(dd, 2, @InsertDate)
		,DATEADD(dd, 3, @InsertDate)
		,DATEADD(dd, 4, @InsertDate))

	SET @RowCount = @RowCount + 1
END
Drop Table dbo.cmonitortest14051123654

SET @EndTime = CURRENT_TIMESTAMP
SELECT ExecutionTimeInMS = DATEDIFF(millisecond , @StartTime, @EndTime)
